/*
 * Decompiled with CFR 0.152.
 */
package pse.util.general;

import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JProgressBar;

public class ProgressCalculator {
    protected JProgressBar progressBar;
    protected String[] stepLabels;
    protected int[] stepStartValues;
    protected int overallEndValue;
    protected int numberOfSteps;
    protected int stageStart = 0;
    protected int stageEnd = 0;
    protected int stageLength = 0;
    protected int stageTotalWork = 0;
    protected boolean inAtomicStage = true;
    protected boolean timerOn = false;
    protected Timer timer;

    public ProgressCalculator(JProgressBar jProgressBar, int[] nArray, String[] stringArray) {
        if (nArray.length != stringArray.length - 1) {
            throw new Error("Length mismatch in creation of ProgressCalculator: stepCosts.length = " + nArray.length + "; stepLabels.length = " + stringArray.length);
        }
        this.progressBar = jProgressBar;
        this.stepLabels = stringArray;
        this.initialize(nArray);
        jProgressBar.setMinimum(0);
        jProgressBar.setMaximum(this.overallEndValue);
        jProgressBar.setValue(0);
        jProgressBar.setIndeterminate(false);
        jProgressBar.setStringPainted(true);
        this.startTimer();
    }

    public void begin() {
        this.progressBar.setValue(0);
    }

    public void startStep(int n) {
        this.initializeStepStart(n);
        this.inAtomicStage = true;
        this.timerOn = true;
    }

    public void startStep(int n, int n2) {
        this.initializeStepStart(n);
        this.inAtomicStage = false;
        this.stageTotalWork = n2;
        this.timerOn = true;
    }

    public void inProgressStep(int n) {
        int n2 = this.stageStart + this.stageLength * n / this.stageTotalWork;
        this.progressBar.setValue(Math.min(n2, this.stageEnd));
    }

    public void timerElapsed() {
        if (this.timerOn && this.inAtomicStage) {
            this.progressBar.setValue(this.stageStart + this.stageTotalWork++);
        }
    }

    public void finishStep() {
        this.timerOn = false;
    }

    public void end() {
        this.timerOn = false;
        this.stopTimer();
        this.progressBar.setValue(this.overallEndValue);
        this.progressBar.setString(this.stepLabels[this.numberOfSteps]);
    }

    protected void initializeStepStart(int n) {
        this.stageStart = this.stepStartValues[n];
        this.stageEnd = this.stepStartValues[n + 1];
        this.stageLength = this.stageEnd - this.stageStart;
        this.progressBar.setValue(this.stageStart);
        this.progressBar.setString(this.stepLabels[n]);
    }

    protected void startTimer() {
        TimerTask timerTask = new TimerTask(){

            public void run() {
                ProgressCalculator.this.timerElapsed();
            }
        };
        this.timer = new Timer("Progress Timer", true);
        this.timer.schedule(timerTask, 1000L, 1000L);
    }

    protected void stopTimer() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    protected void initialize(int[] nArray) {
        this.numberOfSteps = nArray.length;
        this.stepStartValues = new int[this.numberOfSteps + 1];
        this.stepStartValues[0] = 0;
        for (int i = 0; i < this.numberOfSteps; ++i) {
            this.stepStartValues[i + 1] = this.stepStartValues[i] + nArray[i];
        }
        this.overallEndValue = this.stepStartValues[this.numberOfSteps];
    }
}

